#include "VertexShaderSemantics.fx"
#include "FragmentShaderSemantics.fx"

struct VS_IN {
	float4 position		: POSITION;
	float4 colorSet0	: COLOR;
	float3 uvSet0		: TEXCOORD0;	// xy contains UV texture coords, z contains particle "radius" for soft particles
};

struct VS_OUT { 
	float4 position		: POSITION;
	float4 color		: COLOR;	
	float4 texcoord		: TEXCOORD0;		
	float4 texparams       : TEXCOORD1; // used to pass the texsize and maxaniso params in x,y and z
	float4 lodparams       : TEXCOORD2; // used to pass the level of detail params
};

struct PS_IN {
	float4 color		: COLOR;
	float4 texcoord		: TEXCOORD0;
	float4 texparams		: TEXCOORD1; // used to pass the texsize(x,y) and maxaniso params (z)
	float4 lodparams		: TEXCOORD2; // used to pass the level of detail params
};

uniform sampler2D diffuse_tex : register(s0);
// texSize[ tex width, tex height, max aniso samples, UNUSED ]
// LODParam[ LOD Bias, min LOD, max LOD, LOD ISO QUALITY ]
uniform float4 texSize : register(c200);
uniform float4 LODParam : register(c201);

// TODO make this PS3 specific
VS_OUT debugMipMap_vx(VS_IN input)
{
	VS_OUT Out;
	//Out.position = mul(input.position, viewProj); // was viewProj. worldViewProj, worldView and world don't work (360).
	Out.position = mul(mul(input.position, world), viewProj); 
	Out.color = input.colorSet0;
	Out.texcoord.xy = input.uvSet0;
	Out.texcoord.zw = 1;
	// slow but acceptable (debug) way to pass params through to the PS3 fragment shader 
	Out.texparams = texSize; // this pipelining doesn't seem to work on 360.
	Out.lodparams = LODParam;
	return Out;
}

// expects rho in radians. See p50 RSX users manual 2008 Sony/NVidia
inline float vlen( float rho, float4 vX, float4 vY )
{
	float s,c; // sin and cos results
	float4 v; 
	sincos(rho, s, c);
	v = vX*c + vY*s;
	//return sqrt(v.x*v.x +v.y*v.y); // JDW test approx isn't causing the problem
	return length(float4(v.xy,0,0)); // use just x and y derivs	
}

// expects rho in radians. See p50 RSX users manual 2008 Sony/NVidia
inline float vlenlow( float rho, float4 vX, float4 vY )
{
	float s,c; // sin and cos results
	float4 v; 
	sincos(rho, s, c);
	v = vX*c + vY*s;
	return abs(v.x) + abs(v.y); // use just x and y derivs	
}




// inefficient but platform indep. way to select well separated colours for false-colour render
// 1D tex would be nicer but generates many file dependencies
// 8 colours (large hue difference) for LOD 0->7 then 8 and above solid green
inline float4 colour16_8_hue(float LOD)
{
	float4 retcol = float4(0,0,0,1);
	LOD = clamp(floor(LOD+0.5),0,15); 
	if(step(1,LOD))
	{
		if(step(2,LOD))
		{
			if(step(3,LOD))
			{
				if(step(4,LOD))
				{
					if(step(5,LOD))
					{
						if(step(6,LOD))
						{
							if(step(7,LOD))
							{ // LOD >= 7
								if(step(8,LOD))
								{ // LOD >= 8
									retcol = float4(255./255.,255./255.,255./255.,1);									
								}
								else
								{ // LOD == 7
									retcol = float4(0./255.,137./255.,0./255.,1);	
								}																	
							}
							else
							{ // LOD == 6
								retcol = float4(31./255.,196./255.,27./255.,1);
							}
						}
						else
						{ // LOD == 5
							retcol = float4(255./255.,8./255.,252./255.,1);
						}
					}
					else
					{ // LOD == 4
						retcol = float4(8./255.,8./255.,255./255.,1);
					}
				}
				else
				{ // LOD == 3
					retcol = float4(6./255.,196./255.,203./255.,1);
				}
			}
			else
			{ // LOD == 2
				retcol = float4(255./255.,252./255.,8./255.,1);
			}
		}
		else
		{ // LOD == 1
			retcol = float4(255./255.,171./255.,8./255.,1);
		}
	}
	else
	{ // LOD == 0
		retcol = float4(255./255.,8./255.,8./255.,1);
	}
	return retcol;
}


// inefficient but platform indep. way to select well separated colours for false-colour render
// 1D tex would be nicer but generates many file dependencies
// 8 colours (large hue difference) for LOD 0->7 then 8 and above solid green
inline float4 colour16_8_hue_neat(float LOD)
{	
	LOD = clamp(floor(LOD+0.5),0,15); 
	if(LOD >= 8)      return float4(255./255.,255./255.,255./255.,1);
	else if(LOD >= 7) return float4(0./255.,137./255.,0./255.,1);
	else if(LOD >= 6) return float4(31./255.,196./255.,27./255.,1);
	else if(LOD >= 5) return float4(255./255.,8./255.,252./255.,1);
	else if(LOD >= 4) return float4(8./255.,8./255.,255./255.,1);
	else if(LOD >= 3) return float4(6./255.,196./255.,203./255.,1);
	else if(LOD >= 2) return float4(255./255.,252./255.,8./255.,1);
	else if(LOD >= 1) return float4(255./255.,171./255.,8./255.,1);
	else              return float4(255./255.,8./255.,8./255.,1);
}

// Used on RSX, see PS3 docs for cellGcmSetTextureOptimization
inline float lod_modify(float lod, float lod_bias, float slope) {
     lod += lod_bias;
     return floor(lod) + min((lod-floor(lod))*slope, 1);
}


// Calculate the mipmap level which would be used. Display in corresponding false colour.
// See p50 RSX users manual 2008 Sony/NVidia
float4 debugMipMap_px(PS_IN In) : COLOR
{	
	
	
	 // vectors of texture derivatives in x and y directions
	float4 a, c;
		
	a = ddx(float4(In.texcoord.xy*texSize.xy,0,0));	
	c = ddy(float4(In.texcoord.xy*texSize.xy,0,0));	
		
	float dudx = a.x;
	float dvdx = a.y;
	float dudy = c.x;
	float dvdy = c.y;
	
	float scale = 0;
	
	float max_aniso = texSize.z;
	
	if(max_aniso<=1)
	{
		//scale = max( max(vl_45, vl_135), max(vl_0, vl_90));		
		
		/*  Calculate texture scale in the horizontal and vertical screen axis.  */
        float px = sqrt(dudx * dudx + dvdx * dvdx);
        float py = sqrt(dudy * dudy + dvdy * dvdy);	
        scale = max(px,py);
	}
	else
	{			
	    /*  Calculate texture scale in the horizontal and vertical screen axis.  */
        float px = sqrt(dudx * dudx + dvdx * dvdx);
        float py = sqrt(dudy * dudy + dvdy * dvdy);

        /*  Calculate texture scale on the XY/YX axis (axis rotated 45 degrees).  */
        float pxy = sqrt((dudx + dudy) * (dudx + dudy) * 0.5 + (dvdx + dvdy) * (dvdx + dvdy) * 0.5);
        float pyx = sqrt((dudx - dudy) * (dudx - dudy) * 0.5 + (dvdx - dvdy) * (dvdx - dvdy) * 0.5);

        /*  Calculate the minimum and maximum for both axis.  */
        float pMin = min(px, py);
        float pMax = max(px, py);

        /*  Calculate ratio for X/Y axis.  */
        float N = min(pMax/pMin, max_aniso);

        /*  Calculate the minimum and maximum for both axis.  */
        float pMin2 = min(pxy, pyx);
        float pMax2 = max(pxy, pyx);

        /*  Calculate ratio for XY/YX axis.  */
        float N2 = min(pMax2/pMin2, max_aniso);

        /*  Determine which */
        if (N >= N2)
        {
			/*
            if (pMax == px)
                axis = TextureAccess::X_AXIS;
            else
                axis = TextureAccess::Y_AXIS;

            //  Calculate the number of samples required.  
            samples = u32bit(GPU_CEIL(N));
            */

            //  Calculate the texture scale for each sample.  
            //scale = pMax / f32bit(samples);
            scale = pMax / N;
        }
        else
        {
            //  Determine the anisotropy axis.  
            /*
            if (pMax2 == pxy)
                axis = TextureAccess::XY_AXIS;
            else
                axis = TextureAccess::YX_AXIS;
                

            //  Calculate the number of samples required.  
            samples = u32bit(GPU_CEIL(N2));
            */

            //  Calculate the texture scale for each sample.  
            //scale = pMax2 / f32bit(samples);
            scale = pMax2 / N2;
        }
        

	}	
		
	float LOD = log2(scale);	
	//LOD = clamp(LOD + In.lodparams.x, In.lodparams.y, In.lodparams.z); // add LOD bias, then clamp to supplied range	
	//LOD = lod_modify(LOD, 0, 1);	
	//LOD = floor(LOD) + min( ((float)( LOD-floor(LOD) ))*1, 1.0);	
		
	return colour16_8_hue(LOD);			
}

// Calculate the mipmap level which would be used. Display in corresponding false colour.
// See p50 RSX users manual 2008 Sony/NVidia

float4 debugMipMap_px_old(PS_IN In) : COLOR
{		
	float4 retcol = float4(0,0,0,1);
	
	 // vectors of texture derivatives in x and y directions
	float4 a, c;
	
	a = ddx(float4(In.texcoord.xy*texSize.xy,0,0));	
	c = ddy(float4(In.texcoord.xy*texSize.xy,0,0));				
	
	//a = ddx(float4(In.texcoord.xy,0,0));	
	//c = ddy(float4(In.texcoord.xy,0,0));	
	
	//return float4(a.x,0,0,1);
	
	float vl_0 = vlen(0., a, c);
	float vl_45 = vlen(radians(45), a, c);
	float vl_90 = vlen(radians(90), a, c);
	float vl_135 = vlen(radians(135), a, c);
	float p_major = 0;
	float LOD = 0;
	
			
	
	// this outer branch could be removed by defining an ANISO specific shader, but 
	// negligible improvement compared to the extra branching needed for p_minor determination
	
	// NOTE: step(a, b) returns b >= a ? 1 : 0;
	
	

	if(step(2,In.texparams.z)) 
	{
		// logic for anisotropic version, need p_minor which depends on p_major choice
		float p_minor = 0.f;
		
		if(	step(vl_0, vl_45) )
		{ // vl_45 >= vl_0
			if(	step(vl_90, vl_135) )
			{
				if(	step(vl_45, vl_135) )
				{
					p_minor = vl_45;
					p_major = vl_135;
				}
				else
				{
					p_minor = vl_135;
					p_major = vl_45;
				}
			}
			else 
			{
				if(	step(vl_45, vl_90) )
				{
					p_minor = vl_0;
					p_major = vl_90;
				}
				else
				{
					p_minor = vl_135;
					p_major = vl_45;
				}
			}
		}
		else
		{ // vl_0 > vl_45
			if(	step(vl_90, vl_135) )
			{
				if(	step(vl_0, vl_135) )
				{
					p_minor = vl_45;
					p_major = vl_135;
				}
				else
				{
					p_minor = vl_90;
					p_major = vl_0;
				}
			}
			else
			{ // vl_90 > vl_135
				if(	step(vl_0, vl_90) )
				{
					p_minor = vl_0;
					p_major = vl_90;
				}
				else
				{
					p_minor = vl_90;
					p_major = vl_0;
				}
			}
		}
		
		LOD = log2(p_minor);
		//LOD = log2(p_major);

	}
	else
	{
		p_major = max( max(vl_45, vl_135), max(vl_0, vl_90));	
		LOD = log2(p_major); // assume LOD in range 0-15 
	}
	
			
	//LOD = clamp(LOD + LODParam.x, LODParam.y, LODParam.z); // add LOD bias, then clamp to supplied range	
	retcol = colour16_8_hue(LOD);

	//retcol = float4(LOD/16, LOD/16, LOD/16, 1);	
	//return float4(1-LOD.x/16, 1-LOD.x/16, 1-LOD.x/16, 1);	
	
	return retcol;
}


// Calculate the mipmap level which would be used. Display in corresponding false colour.
// See p50 RSX users manual 2008 Sony/NVidia
float4 debugMipMap_RSX_px(PS_IN In) : COLOR
{	
	float4 retcol = float4(0,0,0,1);
	
	 // vectors of texture derivatives in x and y directions
	float4 a, c;
		
	a = ddx(float4(In.texcoord.xy*In.texparams.xy,0,0));	
	c = ddy(float4(In.texcoord.xy*In.texparams.xy,0,0));	
	
	float dudx = a.x;
	float dvdx = a.y;
	float dudy = c.x;
	float dvdy = c.y;
	
	//return a;
	
	float vl_0 = vlen(0., a, c);
	float vl_45 = vlen(radians(45), a, c);
	float vl_90 = vlen(radians(90), a, c);
	float vl_135 = vlen(radians(135), a, c);	
	float p_major = 0;
	float LOD = 0;
	float scale = 0;
	
			
	
	// this outer branch could be removed by defining an ANISO specific shader, but 
	// negligible improvement compared to the extra branching needed for p_minor determination
	
	// NOTE: step(a, b) returns b >= a ? 1 : 0;
	
	float max_aniso = In.texparams.z;
	
	if(max_aniso<=1)
	{
		//scale = max( max(vl_45, vl_135), max(vl_0, vl_90));		
		
		/*  Calculate texture scale in the horizontal and vertical screen axis.  */
        float px = sqrt(dudx * dudx + dvdx * dvdx);
        float py = sqrt(dudy * dudy + dvdy * dvdy);	
        scale = max(px,py);
	}
	else
	{
	
		
		  /*  Calculate texture scale in the horizontal and vertical screen axis.  */
        float px = sqrt(dudx * dudx + dvdx * dvdx);
        float py = sqrt(dudy * dudy + dvdy * dvdy);

        /*  Calculate texture scale on the XY/YX axis (axis rotated 45 degrees).  */
        float pxy = sqrt((dudx + dudy) * (dudx + dudy) * 0.5 + (dvdx + dvdy) * (dvdx + dvdy) * 0.5);
        float pyx = sqrt((dudx - dudy) * (dudx - dudy) * 0.5 + (dvdx - dvdy) * (dvdx - dvdy) * 0.5);

        /*  Calculate the minimum and maximum for both axis.  */
        float pMin = min(px, py);
        float pMax = max(px, py);

        /*  Calculate ratio for X/Y axis.  */
        float N = min(pMax/pMin, max_aniso);

        /*  Calculate the minimum and maximum for both axis.  */
        float pMin2 = min(pxy, pyx);
        float pMax2 = max(pxy, pyx);

        /*  Calculate ratio for XY/YX axis.  */
        float N2 = min(pMax2/pMin2, max_aniso);

        /*  Determine which */
        if (N >= N2)
        {
			/*
            if (pMax == px)
                axis = TextureAccess::X_AXIS;
            else
                axis = TextureAccess::Y_AXIS;

            //  Calculate the number of samples required.  
            samples = u32bit(GPU_CEIL(N));
            */

            //  Calculate the texture scale for each sample.  
            //scale = pMax / f32bit(samples);
            scale = pMax / N;
        }
        else
        {
            //  Determine the anisotropy axis.  
            /*
            if (pMax2 == pxy)
                axis = TextureAccess::XY_AXIS;
            else
                axis = TextureAccess::YX_AXIS;
                

            //  Calculate the number of samples required.  
            samples = u32bit(GPU_CEIL(N2));
            */

            //  Calculate the texture scale for each sample.  
            //scale = pMax2 / f32bit(samples);
            scale = pMax2 / N2;
        }
        

	}	
		
	LOD = log2(scale);	
	//LOD = clamp(LOD + In.lodparams.x, In.lodparams.y, In.lodparams.z); // add LOD bias, then clamp to supplied range	
	LOD = lod_modify(LOD, 0, 1);
	
	//LOD = floor(LOD) + min( ((float)( LOD-floor(LOD) ))*1, 1.0);	
		
	retcol = colour16_8_hue_neat(LOD);	
	return retcol;
	
}

// Calculate the mipmap level which would be used. Display in corresponding false colour.
// See p50 RSX users manual 2008 Sony/NVidia
float4 debugMipMap_RSX_px_old(PS_IN In) : COLOR
{	
	float4 retcol = float4(0,0,0,1);
	
	 // vectors of texture derivatives in x and y directions
	float4 a, c;
		
	a = ddx(float4(In.texcoord.xy*In.texparams.xy,0,0));	
	c = ddy(float4(In.texcoord.xy*In.texparams.xy,0,0));	
	
	//return a;
	
	float vl_0 = vlen(0., a, c);
	float vl_45 = vlen(radians(45), a, c);
	float vl_90 = vlen(radians(90), a, c);
	float vl_135 = vlen(radians(135), a, c);	
	float p_major = 0;
	float LOD = 0;
	
			
	
	// this outer branch could be removed by defining an ANISO specific shader, but 
	// negligible improvement compared to the extra branching needed for p_minor determination
	
	// NOTE: step(a, b) returns b >= a ? 1 : 0;
	
		
	if(step(2,In.texparams.z)) 
	{
		// logic for anisotropic version, need p_minor which depends on p_major choice
		float p_minor = 0.f;
			
		if(	step(vl_0, vl_45) )
		{ // vl_45 >= vl_0
			if(	step(vl_90, vl_135) )
			{
				if(	step(vl_45, vl_135) )
				{
					p_minor = vl_45;
					p_major = vl_135;
				}
				else
				{
					p_minor = vl_135;
					p_major = vl_45;
				}
			}
			else 
			{
				if(	step(vl_45, vl_90) )
				{
					p_minor = vl_0;
					p_major = vl_90;
				}
				else
				{
					p_minor = vl_135;
					p_major = vl_45;
				}
			}
		}
		else
		{ // vl_0 > vl_45
			if(	step(vl_90, vl_135) )
			{
				if(	step(vl_0, vl_135) )
				{
					p_minor = vl_45;
					p_major = vl_135;
				}
				else
				{
					p_minor = vl_90;
					p_major = vl_0;
				}
			}
			else
			{ // vl_90 > vl_135
				if(	step(vl_0, vl_90) )
				{
					p_minor = vl_0;
					p_major = vl_90;
				}
				else
				{
					p_minor = vl_90;
					p_major = vl_0;
				}
			}
		}
		
		
		
		//LOD = log2(p_minor);
		//LOD = log2(p_major);
		LOD = log2(p_major);

	}
	else
	{
		p_major = max( max(vl_45, vl_135), max(vl_0, vl_90));	
		LOD = log2(p_major); // assume LOD in range 0-15 
	}
			
	//LOD = clamp(LOD + In.lodparams.x, In.lodparams.y, In.lodparams.z); // add LOD bias, then clamp to supplied range	
	LOD = lod_modify(LOD, 0, 1);
	
	//LOD = floor(LOD) + min( ((float)( LOD-floor(LOD) ))*1, 1.0);
	
	
	
	
	//return float4(1-LOD.x/16, 1-LOD.x/16, 1-LOD.x/16, 1);	
	retcol = colour16_8_hue(LOD);	
	return retcol;
	
}


/*
// Calculate the mipmap level which would be used. Display in corresponding false colour.
// See p50 RSX users manual 2008 Sony/NVidia
float4 debugMipMap_RSX_low_px(PS_IN In) : COLOR
{	
	float4 retcol = float4(0,0,0,1);
	
	 // vectors of texture derivatives in x and y directions
	float4 a, c;
		
	a = ddx(float4(In.texcoord.xy*In.texparams.xy,0,0));	
	c = ddy(float4(In.texcoord.xy*In.texparams.xy,0,0));			
	
	//return float4(a.x,0,0,1);
	
	float LOD=0;
	
	// because of CELL_GCM_TEXTURE_ANISO_LOW only sample two directions...
	
	if(step(2,In.texparams.z)) 
	{
		// ANISO LOD QUAL is set LOW in nuapi for PS3, so only 2 directions
		// logic for anisotropic version, need p_minor which depends on p_major choice
		float p_minor = 0.f;
		float p_major = 0.f;
		
		float vl_0 = vlenlow(0., a, c);			
		float vl_90 = vlenlow(radians(90), a, c);
		p_minor = min(vl_0, vl_90);		
		
		LOD = log2(p_minor);		
	}		
	else
	{
		// ISO LOD QUAL is HIGH
		float vl_0 = vlen(0., a, c);
		float vl_45 = vlen(radians(45), a, c);
		float vl_90 = vlen(radians(90), a, c);
		float vl_135 = vlen(radians(135), a, c);
		
		float p_major = max( max(vl_45, vl_135), max(vl_0, vl_90));
		LOD = log2(p_major);
	}
	
			
	//LOD = clamp(LOD + In.lodparams.x, In.lodparams.y, In.lodparams.z); // add LOD bias, then clamp to supplied range	
	LOD = lod_modify(LOD, 0, 2);
	
	return colour16_8_hue(LOD);	
}
*/

#ifdef _360_TARGET
// Display mipmap level ACTUALLY used. Display in corresponding false colour.
float4 debugMipMapAlt_px(PS_IN In) : COLOR
{			
	float4 lod = float4(0,0,0,0);
	
	//float4 tc = float4(In.texcoord.x * texSize.x, In.texcoord.y * texSize.y, 0, 0);
	//asm { getCompTexLOD2D lod, tc, diffuse_tex, UnnormalizedTextureCoords = true };
	
	float4 tc = float4(In.texcoord.x, In.texcoord.y,0,0);	
	asm { getCompTexLOD2D lod, tc, diffuse_tex, UnnormalizedTextureCoords = false };
	//return float4(1-lod.x/16, 1-lod.x/16, 1-lod.x/16, 1);	
	return colour16_8_hue(lod.x);
}
#endif

